package com.young.tools.experiment.screentest;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.Display;
import android.view.WindowManager;
import android.widget.TextView;

import com.young.tools.experiment.R;
import com.young.tools.experiment.util.SystemUtil;
import com.young.tools.experiment.util.ViewUtil;

import butterknife.BindView;
import butterknife.ButterKnife;

public class ScreenTestActivity extends AppCompatActivity {

    @BindView(R.id.tvTip)
    TextView tvTip;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_screen_test);
        ButterKnife.bind(this);

        Display display = getWindowManager().getDefaultDisplay();
        int width, height;
        if (android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.HONEYCOMB_MR2) {
             width = display.getWidth();
             height = display.getHeight();
        } else {
            Point size = new Point();
            display.getSize(size);
             width = size.x;
             height = size.y;
        }

        String tp = "Screen width : " + width + " px, " + ViewUtil.pxToDp(this,width) + " dp\n" +
                "height: " + height + " px, " + ViewUtil.pxToDp(this,height) + " dp\n";
        tp = tp + "Brand: " + SystemUtil.getDeviceBrand() + " " + SystemUtil.getSystemModel() + " " + SystemUtil.getSystemVersion() ;

        tvTip.setText(tp);
    }
}
