## 四轮科技docker开发环境

- 声明：仅在mac环境下投入使用，Windows理论上可用；本项目已是工作目录，最好不要放在子项目下
- mysql、redis暂无使用
- topka项目未接入在内，依旧是在虚拟机内运行

### 使用前准备

- 请自行前往docker官网下载新版docker或者升级本机docker版本
- docker官网链接：https://docs.docker.com/docker-for-mac/install/
- mac环境下使用resolver解析本容器dns,命令如下
```
sudo mkdir /etc/resolver
sudo touch /etc/resolver/test
sudo vi /etc/resolver/test 
写入
nameserver 127.0.0.1
```

### 使用步骤

```
1.将自己的私钥放入本目录内，方便在 http://c9.test (账户:密码：root:root,浏览器ide)操作git
2.数据使用虚拟机内的，所以这里只启动这两个
命令：docker-compose up -d workspace dns
3.启动gulp容器 请在当前gulp目录内执行 -p 后端口按实际需要使用
docker run -itd -v $PWD:/gulp -p 3000:3000 --name gulp cnice/piston:1.0.0
如需使用gulp命令进入容器内：docker exec -it gulp bash
```

### 解读

- 由于使用了dns与resolver解析器 所以nginx配置的路由以.test为结尾的地址无需修改hosts文件

```
目录结构说明
├── gulp (需要gulp的项目)
│  ├── layui-agent
│  └── piston
│  └── ...
├── laravel (laravel项目 php7.1)
│  ├── dealer
│  └── promotion
│  └── ...
├── vue (vue项目)
│  ├── dealer
│  └── promotion
│  └── ...
├── dns
│  └── dnsmasq.conf
├── storage (数据存放)
│  ├── redis
│  └── mysql
│  └── ...
├── .gitignore
├── c9.conf
├── docker-compose.yml
├── html.conf (前端 nginx配置)
├── php.conf (php nginx配置)
├── README.md
```