## 四轮科技docker开发环境

- 本项目已是工作目录，最好不要放在子项目下

### 使用前准备

- 请自行前往docker官网下载新版docker或者升级本机docker版本
- docker官网链接：https://docs.docker.com/docker-for-mac/install/
- mac环境下使用resolver解析容器dns(由于试验.loacl后缀无法生效，故采用.test后缀),命令如下
```
sudo mkdir /etc/resolver
sudo touch /etc/resolver/test
sudo vi /etc/resolver/test 
写入
nameserver 127.0.0.1
```

### 使用步骤

```
1.初始化
- 说明：拉取镜像，构建容器
- 命令：docker-compose up -d
2.进入容器内：docker exec -it 容器名 sh
```

### 解读

- 由于使用了dns与resolver解析器 所以nginx配置的路由以.test为结尾的地址无需修改hosts文件

```
目录结构说明
├── config
│  └── dns
│  │   └── dnsmasq.conf
│  └── nginx
│  │   └── html.conf
│  │   └── php.conf
│  └── ...
├── laravel
│  ├── dealer
│  └── promotion
│  └── ...
├── web
│  ├── dealer
│  └── promotion
│  ├── layui-agent
│  └── piston
│  └── ...
├── storage (数据存放)
│  ├── redis
│  └── mysql
│  └── ...
├── .gitignore
├── docker-compose.yml
└── README.md
```