# 项目宗旨

1. 熟悉 Git 的使用
2. 熟悉 Git flow 工作流
3. 熟悉 Git GUI 工具 `SourceTree` 的使用方法
4. 熟悉 Markdown 的写作语法

# 先期准备与配置

1. 指 Host
  
    打开 Host 文件，Mac 和 Linux 下为 `/etc/hosts`（windows 下请自行百度），添加如下内容：

    ```
    192.168.0.231 git.hezuo.tk
    ```

2. 在邮箱中查找发件为 `gitlab` ，邮件标题为：`Accout was created for you` 的邮件。

    1. 根据邮件中的帐号与密码信息登陆 `http://git.hezuo.tk`
    2. 根据系统提示，完成修改默认密码、重新登陆系统等操作。
      
3. 进入系统后，点击右上角 `Profile settings` （从右向左数第三个图标）
4. 点击顶部二级导航栏 `SSH Keys` 项
    
    点击右上角 `Add SSH Key` 按键，将你的私人密钥的公钥粘贴进 `Key` 项。点击 `Add Key` 保存。
    
    不了解密钥的同事可以请运维部的同学帮忙。
    
5. 测试成功连接 `git` 系统

    ```
    git clone git@git.hezuo.tk:tech/hello-gitlab.git
    ```
    
    返回如下信息则表明设置正确，已经成功连接 `git` 系统。
    
    ```console
    Checking connectivity... done.
    ```
    
6. 【附加任务】

    1. 下载安装 `git` GUI客户端SourceTree

        访问 `http://www.sourcetreeapp.com/`，下载 Mac 版或 Windows 版 SourceTree
    
    2. 非 Mac 用户安装 git-flow 
    
    3. Mac 用户安装 `zsh`，并安装 `zsh` 的 `git flow` 插件。

# 任务步骤

## Level 1

1. 学会从 `git` 系统 clone 项目至本地

    ```
    $ git clone git@git.hezuo.tk:tech/gitlevel.git
    ```
    
    切换到 `develop` 分支
    
    ```console
    $ git checkout -b develop origin/develop
    ```
    
    并在项目根目录运行
    
    ```console
    $ git flow init
    ```
    
2. 开始一个新任务
        
    ```
    $ git flow feature start your.name
    ```
    
    **注意：使用当前登陆系统的用户名代替 `your.name`**
    
3. 在项目根目录下新建一个文本文件，文件名 `your.name.txt`，并在文件内写上如下内容：

    ```php
    <?php echo phpinfo(); ?>
    ```

    **注意：使用当前登陆系统的用户名代替 `your.name`**
    
4. 添加文件并提交

    在项目根目录下执行：

    ```console
    $ git add your.name.txt
    ```
 
 5. 提交变更

 在项目根目录下执行：

 ```console
 $ git commit -m "add your.name.txt"
 ```

6. 完成任务

    在项目根目录下执行：
    
    ```console
    $ git flow feature finish your.name
    ```  
    **注意：此处 `your.name` 和第二步开始新任务中的your.name要保持一致。**
    
7. 向远程版本库推送刚才的提交

    在项目根目录下执行：
    
    ```console
    $ git push origin develop
    ```

## Level 2

  待添加
    
# 任务完成

  发送邮件至 `liu.song@topka.cn`，说明完成任务的等级。
